<img src="assets/img/contorno.png" class="img_contorno"/>
<canvas id="canvas" width="500" height="500" style="width: 100%;"></canvas><br /><br />
<center>
  <input type="button" class="btn btn-primary" value="Girar" id='spin' /><br /><br />
  <form method="POST" action="registro_intento.php">
    <input type="hidden" class="btn btn-primary" id='id_usuario_hidden' name="documento" value="<?php echo $cedula ?>"/>
    <input type="text" class="btn btn-primary" id='premio' name="premio" value="" style="display:none;" />
    <input type="text" class="btn btn-primary" id='precio' name="precio_combustible" value="<?php echo $precio_combus ?>" style="display:none;" />
    <input type="submit" value="Volver" name="agregar_registro" id="action" class="btn btn-danger"><br /><br />
  </form>
</center>

<script type="text/javascript">
var options = ["SIGA PARTICIPANDO", "SIGA PARTICIPANDO", "SIGA PARTICIPANDO", "PREMIO PLATCOM", "SIGA PARTICIPANDO", "SIGA PARTICIPANDO", "PREMIO NEWSEXPRESS", "SIGA PARTICIPANDO", "SIGA PARTICIPANDO", "PREMIO FONIX", "SIGA PARTICIPANDO", "SIGA PARTICIPANDO", "SIGA PARTICIPANDO", "PREMIO TU PAIS", "SIGA PARTICIPANDO", "SIGA PARTICIPANDO"];
var startAngle = 0;
var arc = Math.PI / (options.length / 2);
var spinTimeout = null;

var spinArcStart = 30;
var spinTime = 0;
var spinTimeTotal = 0;

var ctx;

document.getElementById("spin").addEventListener("click", spin);

function byte2Hex(n) {
  var nybHexString = "0123456789ABCDEF";
  return String(nybHexString.substr((n >> 4) & 0x0E,1)) + nybHexString.substr(n & 0x0F,1);
}

function RGB2Color(r,g,b) {
    return '#' + byte2Hex(r) + byte2Hex(g) + byte2Hex(b);
}

function getColor(item, maxitem) {
  var phase = 4;
  var center = 235;
  var width = 85;
  var frequency = Math.PI*2/4;
  
  red   = Math.sin(frequency*item+120+phase) * width + center;
  green = Math.sin(frequency*item+80+phase) * width + center;
  blue  = Math.sin(frequency*item+0+phase) * width + center;
  
  return RGB2Color(red,green,blue);
}

function drawRouletteWheel() {
  var canvas = document.getElementById("canvas");
  if (canvas.getContext) {
    var outsideRadius = 220;
    var textRadius = 125;
    var insideRadius = 10;

    ctx = canvas.getContext("2d");
    ctx.clearRect(0,0,500,500);

    ctx.strokeStyle = "#FFFFFF";
    ctx.font = 'bold 14px Poppins, sans-serif';

    for(var i = 0; i < options.length; i++) {
      var angle = startAngle + i * arc;
      ctx.fillStyle = getColor(i, options.length);

      ctx.beginPath();
      ctx.arc(255, 255, outsideRadius, angle, angle + arc, false);
      ctx.arc(255, 255, insideRadius, angle + arc, angle, true);
      ctx.stroke();
      ctx.fill();

      ctx.save();
      ctx.shadowOffsetX = 1;
      ctx.shadowOffsetY = 1;
      ctx.shadowBlur    = 0;
      ctx.fillStyle = "#ffffff";
      ctx.translate(255 + Math.cos(angle + 0.4 / 2) * textRadius, 
                    255 + Math.sin(angle + 0.4 / 2) * textRadius);
      ctx.rotate(angle + 255 / 2 + Math.PI / 2);
      var text = options[i];
      ctx.fillText(text, -ctx.measureText(text).width / 2, 0);
      ctx.restore();
    } 

    //Arrow
    ctx.fillStyle = "yellow";
    ctx.beginPath();
    ctx.moveTo(250 - 4, 250 - (outsideRadius + 10));
    ctx.lineTo(250 + 4, 250 - (outsideRadius + 10));
    ctx.lineTo(250 + 4, 250 - (outsideRadius - 10));
    ctx.lineTo(250 + 9, 250 - (outsideRadius - 10));
    ctx.lineTo(250 + 0, 250 - (outsideRadius - 25));
    ctx.lineTo(250 - 9, 250 - (outsideRadius - 10));
    ctx.lineTo(250 - 4, 250 - (outsideRadius - 10));
    ctx.lineTo(250 - 4, 250 - (outsideRadius + 10));
    ctx.fill();
  }
}

function spin() {
  var attempts = localStorage.getItem('attempts') || 0;
  attempts = parseInt(attempts);

  // Si el intento es múltiplo de 15, garantizamos el premio especial
  if ((attempts + 1) % 15 === 0) {
    var specialIndex = options.indexOf("PREMIO ESPECIAL RODIZIO");
    var degrees = specialIndex * (360 / options.length);
    startAngle = (360 - degrees) * Math.PI / 180;
    stopRotateWheel(true); // Pasamos true para indicar que es un giro especial
    localStorage.setItem('attempts', attempts + 1);
    return;
  }

  // Incrementar y almacenar el número de intentos
  localStorage.setItem('attempts', attempts + 1);

  spinAngleStart = Math.random() * 10 + 10;
  spinTime = 0;
  spinTimeTotal = 30 * 1000; // 30 segundos
  rotateWheel();
}

function rotateWheel() {
  spinTime += 30;
  if (spinTime >= spinTimeTotal) {
    stopRotateWheel(false);
    return;
  }
  var spinAngle = spinAngleStart - easeOut(spinTime, 0, spinAngleStart, spinTimeTotal);
  startAngle += (spinAngle * Math.PI / 180);
  drawRouletteWheel();
  spinTimeout = setTimeout(rotateWheel, 30);
}

function stopRotateWheel(isSpecialSpin) {
  clearTimeout(spinTimeout);

  var degrees = startAngle * 180 / Math.PI + 90;
  var arcd = arc * 180 / Math.PI;
  var index = Math.floor((360 - degrees % 360) / arcd);
  ctx.save();
  ctx.font = 'bold 20px Helvetica, Arial';
  var text = options[index];
  document.getElementById('premio').value = text;
  swal("Gracias por participar!", "'" + text + "'", "success");
  document.getElementById('action').value = "Confirmar intento";
  document.getElementById('spin').style.display='none';
  ctx.restore();
}

function easeOut(t, b, c, d) {
  var ts = (t/=d)*t;
  var tc = ts*t;
  return b+c*(tc + -3*ts + 3*t);
}

drawRouletteWheel();
</script>